/******/ (() => { // webpackBootstrap
/******/ 	"use strict";

;// ./instrumentation.js
const dataLayer = window._expDataLayer || [];

// See https://godaddy-corp.atlassian.net/wiki/spaces/CKPT/pages/92315197/3.+Logging+Page+Views+for+TCCL
const logPageEvent = page => {
  dataLayer.push({
    schema: 'add_page_view',
    version: 'v1',
    data: {
      path: '/' + page
    }
  });
};

/**
 * Logs an interaction event to Traffic.
 * @param {string} eid represent the data eid to track.
 * @param {string} type can be one of 'click', 'hover', 'touch', 'custom'
 * @param {object} data custom data to be logged.
 */
const logInteractionEvent = ({
  eid,
  type = 'click',
  data = null
}) => {
  dataLayer.push({
    schema: 'add_event',
    version: 'v1',
    data: {
      eid: `${eid}.${type}`,
      type,
      custom_properties: data
    }
  });
};

// See https://godaddy-corp.atlassian.net/wiki/spaces/CKPT/pages/92315189/4.+Logging+Events+for+TCCL
const logImpressionEvent = eid => {
  dataLayer.push({
    schema: 'add_event',
    version: 'v1',
    data: {
      type: 'impression',
      eid: eid + '.impression'
    }
  });
};
;// external ["wp","blocks"]
const external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// ./block-validation-tracker.js
/**
 * Use data-store to get list of validated blocks.
 * Report invalid blocks with their validation problems.
 */



(function (wp) {
  const subscribe = wp?.data?.subscribe;
  const select = wp?.data?.select;
  const dispatch = wp?.data?.dispatch;
  let isChecked = false;

  // Bail if missing anything.
  if (!subscribe || !select || !dispatch || !wp) {
    return;
  }
  if (typeof logInteractionEvent !== 'function' || typeof external_wp_blocks_namespaceObject.serialize !== 'function') {
    return;
  }
  function findInvalidBlocks(blocks) {
    let invalidBlocks = [];
    blocks.forEach(block => {
      if (block.isValid === false) {
        invalidBlocks.push({
          name: block.name,
          validationIssues: block.validationIssues,
          serializedBlock: (0,external_wp_blocks_namespaceObject.serialize)(block)
        });
      } else {
        if (block.innerBlocks && block.innerBlocks.length > 0) {
          invalidBlocks = invalidBlocks.concat(findInvalidBlocks(block.innerBlocks));
        }
      }
    });
    return invalidBlocks;
  }
  function checkBlockForValidity() {
    let blocks = select('core/block-editor').getBlocks();
    let invalidBlocks = findInvalidBlocks(blocks);
    if (invalidBlocks.length > 0) {
      logInteractionEvent({
        eid: 'block-validation-failed',
        type: 'event',
        data: invalidBlocks
      });
    }
    isChecked = true;
  }
  let unsubscribe = subscribe(function () {
    let isEditorReady = select('core/editor')?.isCleanNewPost() !== null;
    let hasBlocks = select('core/block-editor')?.getBlockCount() > 0;
    if (isEditorReady && hasBlocks) {
      if (!isChecked) {
        unsubscribe();
      }
      setTimeout(checkBlockForValidity(), 2000);
    }
  });
})(window?.wp);
/******/ })()
;