<?php


if (!isset($_SERVER['HTTP_X_MWP_SIG'])) {
    die("Missing signature");
}

// sig :: keyid,timestamp_u64,nonce_hex:sig

$sig_fields = explode(':', $_SERVER['HTTP_X_MWP_SIG']);

$sig_input = $sig_fields[0];
$signature = hex2bin($sig_fields[1]);

$sig_inputs = explode(',', $sig_input);
$keyid = (int)$sig_inputs[0];
$timestamp = (int)$sig_inputs[1];
$nonce_hex = $sig_inputs[2];

// check timestamp not too old
if ($timestamp < (time() - 60)) {
    die("request signature expired");
}


//======
// verify the caller
// nowdoc (since PHP 5.3.0)
// @jhardy generated by openssl - 2021-09-11 
$pubkey1 = <<<'EOD'
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2WN1RnyTEJbHq7/5Qnjm
zWuuYGFLzDYoTV1PBfOshLVf84hOP0Mh4dLO9wiRqmHq8ryFgf2ira1K7LCJyeew
bgQO4WrEIxZcYkptv9MSbjvNJ8BWaP0rRTxqTcdzO+gK1Zxu6qriR1tolYAS5QRB
RINBLMLDa+okRwrk0MOw9ns69M0rSkac1GqRLh+47KYz/7P1tBqG85GjtztNdT0k
opmSpzOt13gqcj0aPE8oB5bImA/2PixmCdfWoguZG7joUft2RZSX2Ix8jjL4nNFD
MbSIp6sVbqkeZmHpwdc3k205nDp7i//mCHytotdSO29DDcTssRJeEU1EgKQgnhKT
twIDAQAB
-----END PUBLIC KEY-----
EOD;



$pubkeys = [
    1 => $pubkey1,
];

$cert = $pubkeys[$keyid];
if (!$cert) {
    die("Unknown key: " . $keyid);
}

$pubkeyid = openssl_pkey_get_public($cert);
$ok = openssl_verify($sig_input, $signature, $pubkeyid, OPENSSL_ALGO_SHA256);

if ($ok != 1) {
    die("request signature invalid");
}
